#include <stdio.h>		/* For printf */
#include "e1432.h"

#define	SIZE	1024
/*#define	NOPRINT*/

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    struct e1432_hwconfig hwconfig[2];
    int     i, nchan, status;
    FLOATSIZ64 buffer[SIZE];
    LONGSIZ32 count;
    SHORTSIZ16 laddr[2];
    SHORTSIZ16 chan_list[2];
    SHORTSIZ16 group;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    e1432_set_try_recover(0);
    e1432_trace_level(0);
    e1432_debug_level(0);

    laddr[0] = 8;
    laddr[1] = 9;

    status = e1432_get_hwconfig(2, laddr, hwconfig);
    CHECK(e1432_print_errors(1));
    if (status < 0)
	CHECK(e1432_install(2, laddr, 0, "/opt/e1432/lib/sema.bin"));

#if 1
    CHECK(e1432_get_hwconfig(2, laddr, hwconfig));
    (void) printf("Logical address %d:\n", laddr[0]);
    (void) printf("man_id       = 0x%x\n", hwconfig[0].man_id);
    (void) printf("model_code   = 0x%x\n", hwconfig[0].model_code);
    (void) printf("hw_rev       = %d\n", hwconfig[0].hw_rev);
    (void) printf("bootrom_rev  = %d\n", hwconfig[0].bootrom_rev);
    (void) printf("fw_rev       = %ld\n", hwconfig[0].fw_rev);
    (void) printf("sca_id[0]    = %d\n", hwconfig[0].sca_id[0]);
    (void) printf("sca_id[1]    = %d\n", hwconfig[0].sca_id[1]);
    (void) printf("sca_id[2]    = %d\n", hwconfig[0].sca_id[2]);
    (void) printf("sca_id[3]    = %d\n", hwconfig[0].sca_id[3]);
    (void) printf("sca_id[4]    = %d\n", hwconfig[0].sca_id[4]);
    (void) printf("sca_rev[0]   = %d\n", hwconfig[0].sca_rev[0]);
    (void) printf("sca_rev[1]   = %d\n", hwconfig[0].sca_rev[1]);
    (void) printf("sca_rev[2]   = %d\n", hwconfig[0].sca_rev[2]);
    (void) printf("sca_rev[3]   = %d\n", hwconfig[0].sca_rev[3]);
    (void) printf("sca_rev[4]   = %d\n", hwconfig[0].sca_rev[4]);
    (void) printf("bob_id[0]    = %d\n", hwconfig[0].bob_id[0]);
    (void) printf("bob_id[1]    = %d\n", hwconfig[0].bob_id[1]);
    (void) printf("bob_id[2]    = %d\n", hwconfig[0].bob_id[2]);
    (void) printf("bob_id[3]    = %d\n", hwconfig[0].bob_id[3]);
    (void) printf("bob_id[4]    = %d\n", hwconfig[0].bob_id[4]);
    (void) printf("total_chans  = %d\n", hwconfig[0].total_chans);
    (void) printf("input_chans  = %d\n", hwconfig[0].input_chans);
    (void) printf("source_chans = %d\n", hwconfig[0].source_chans);
    (void) printf("tach_chans   = %d\n", hwconfig[0].tach_chans);
    (void) printf("lbus_present = %d\n", hwconfig[0].lbus_present);
    (void) printf("dram_size    = 0x%lx\n", hwconfig[0].dram_size);
    (void) printf("a24_used     = 0x%lx\n", hwconfig[0].a24_used);
    (void) printf("serial       = %s\n", hwconfig[0].serial);
    (void) printf("\n");
    (void) printf("Logical address %d:\n", laddr[1]);
    (void) printf("man_id       = 0x%x\n", hwconfig[1].man_id);
    (void) printf("model_code   = 0x%x\n", hwconfig[1].model_code);
    (void) printf("hw_rev       = %d\n", hwconfig[1].hw_rev);
    (void) printf("bootrom_rev  = %d\n", hwconfig[1].bootrom_rev);
    (void) printf("fw_rev       = %ld\n", hwconfig[1].fw_rev);
    (void) printf("sca_id[0]    = %d\n", hwconfig[1].sca_id[0]);
    (void) printf("sca_id[1]    = %d\n", hwconfig[1].sca_id[1]);
    (void) printf("sca_id[2]    = %d\n", hwconfig[1].sca_id[2]);
    (void) printf("sca_id[3]    = %d\n", hwconfig[1].sca_id[3]);
    (void) printf("sca_id[4]    = %d\n", hwconfig[1].sca_id[4]);
    (void) printf("sca_rev[0]   = %d\n", hwconfig[1].sca_rev[0]);
    (void) printf("sca_rev[1]   = %d\n", hwconfig[1].sca_rev[1]);
    (void) printf("sca_rev[2]   = %d\n", hwconfig[1].sca_rev[2]);
    (void) printf("sca_rev[3]   = %d\n", hwconfig[1].sca_rev[3]);
    (void) printf("sca_rev[4]   = %d\n", hwconfig[1].sca_rev[4]);
    (void) printf("bob_id[0]    = %d\n", hwconfig[1].bob_id[0]);
    (void) printf("bob_id[1]    = %d\n", hwconfig[1].bob_id[1]);
    (void) printf("bob_id[2]    = %d\n", hwconfig[1].bob_id[2]);
    (void) printf("bob_id[3]    = %d\n", hwconfig[1].bob_id[3]);
    (void) printf("bob_id[4]    = %d\n", hwconfig[1].bob_id[4]);
    (void) printf("total_chans  = %d\n", hwconfig[1].total_chans);
    (void) printf("input_chans  = %d\n", hwconfig[1].input_chans);
    (void) printf("source_chans = %d\n", hwconfig[1].source_chans);
    (void) printf("tach_chans   = %d\n", hwconfig[1].tach_chans);
    (void) printf("lbus_present = %d\n", hwconfig[1].lbus_present);
    (void) printf("dram_size    = 0x%lx\n", hwconfig[1].dram_size);
    (void) printf("a24_used     = 0x%lx\n", hwconfig[1].a24_used);
    (void) printf("serial       = %s\n", hwconfig[1].serial);
#endif

    CHECK(e1432_assign_channel_numbers(2, laddr, &hw));

    /* Create channel group */
    nchan = 2;
    chan_list[0] = E1432_INPUT_CHAN(1);
    chan_list[1] = E1432_INPUT_CHAN(hwconfig[0].input_chans + 1);
    group = e1432_create_channel_group(hw, nchan, chan_list);
    if (group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    group));
	return -1;
    }

    CHECK(e1432_set_blocksize(hw, group, SIZE));

    /* Start measurement */
    CHECK(e1432_init_measure(hw, group));

    for ( ; ; )
    {
	/* Wait for block available */
	while ((status = e1432_block_available(hw, group)) == 0);
	if (status > 0)
	{
#ifndef	NOPRINT
	    (void) printf("Block available found!\n");
#endif
	}
	else
	{
	    DEBUG((void) printf("Error %d from e1432_block_available\n",
				status));
	    return -1;
	}

	/* Read some data */
	for (i = 0; i < nchan; i++)
	{
	    /* Read some data */
	    CHECK(e1432_read_float64_data(hw, chan_list[i],
					  E1432_TIME_DATA, buffer,
					  SIZE, NULL, &count));
	    if (count != SIZE)
	    {
		DEBUG((void) printf("Actual count was %d\n", count));
		return -1;
	    }

#ifndef	NOPRINT
	    (void) printf("Chan %d first four data samples:  %g, %g, %g, %g\n",
			  i + 1, *buffer, *(buffer + 1),
			  *(buffer + 2), *(buffer + 3));
#endif
	}
    }
    /*NOTREACHED*/
    return 0;
}
